VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmMain 
   Caption         =   "VB500serial - Main Form"
   ClientHeight    =   8550
   ClientLeft      =   1740
   ClientTop       =   1575
   ClientWidth     =   9885
   LinkTopic       =   "Form1"
   ScaleHeight     =   8550
   ScaleWidth      =   9885
   Begin VB.TextBox txtBaudRate 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5520
      Locked          =   -1  'True
      TabIndex        =   3
      Text            =   "9600"
      Top             =   1560
      Width           =   750
   End
   Begin VB.TextBox txtCOMport 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1560
      TabIndex        =   1
      Text            =   "1"
      Top             =   1560
      Width           =   375
   End
   Begin VB.CommandButton cmdConfigPort 
      Caption         =   "Config COM Port"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   7800
      TabIndex        =   4
      Top             =   1440
      Width           =   1695
   End
   Begin VB.CommandButton cmdEnterResp 
      Caption         =   "Enter Response"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   7800
      TabIndex        =   8
      Top             =   3960
      Width           =   1695
   End
   Begin VB.CommandButton cmdSendInterface 
      Caption         =   "Send Interface Command"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   7800
      TabIndex        =   7
      Top             =   3360
      Width           =   1695
   End
   Begin VB.TextBox txtInterfaceCmd 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1800
      TabIndex        =   6
      Text            =   "Enter Interface command here"
      Top             =   3420
      Width           =   5655
   End
   Begin VB.TextBox txtAddress 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2160
      TabIndex        =   10
      Text            =   "16"
      Top             =   5220
      Width           =   495
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Init Interface"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   7800
      TabIndex        =   5
      Top             =   2160
      Width           =   1695
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   7800
      TabIndex        =   17
      Top             =   7710
      Width           =   1695
   End
   Begin VB.CommandButton cmdInstruct 
      Caption         =   "Show Instructions"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   7800
      TabIndex        =   18
      Top             =   6600
      Width           =   1695
   End
   Begin VB.TextBox txtResponse 
      Appearance      =   0  'Flat
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1125
      Left            =   1680
      MultiLine       =   -1  'True
      TabIndex        =   16
      Text            =   "frmMain.frx":0000
      Top             =   7080
      Width           =   5775
   End
   Begin VB.CommandButton cmdSendSCPI 
      Caption         =   "Send SCPI Command"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   7800
      TabIndex        =   14
      Top             =   5670
      Width           =   1695
   End
   Begin VB.TextBox txtSCPIcmd 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2160
      TabIndex        =   13
      Text            =   "Enter SCPI command here"
      Top             =   5820
      Width           =   5295
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   9000
      Top             =   120
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
      Handshaking     =   2
      RTSEnable       =   -1  'True
   End
   Begin VB.Label Label10 
      Caption         =   "Label10 - Filled in via code"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   360
      TabIndex        =   25
      Top             =   6600
      Width           =   7095
   End
   Begin VB.Line Line5 
      X1              =   240
      X2              =   9600
      Y1              =   6360
      Y2              =   6360
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "GPIB Address:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   9
      Top             =   5280
      Width           =   1575
   End
   Begin VB.Label Label5 
      Caption         =   "Label5 - Filled in via code"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   360
      TabIndex        =   24
      Top             =   3000
      Width           =   9135
   End
   Begin VB.Line Line4 
      X1              =   240
      X2              =   9600
      Y1              =   2760
      Y2              =   2760
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Baud Rate (19200 Max):"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3120
      TabIndex        =   2
      Top             =   1620
      Width           =   2295
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "COM Port:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   1620
      Width           =   1095
   End
   Begin VB.Label Label7 
      Caption         =   "Label7 - Filled in via code"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   360
      TabIndex        =   23
      Top             =   4800
      Width           =   9135
   End
   Begin VB.Line Line3 
      X1              =   240
      X2              =   9600
      Y1              =   4560
      Y2              =   4560
   End
   Begin VB.Label Label6 
      Alignment       =   1  'Right Justify
      Caption         =   "Interface Cmd:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   12
      Top             =   3480
      Width           =   1335
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Label4 - Filled in via code"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   360
      TabIndex        =   22
      Top             =   2280
      Width           =   5895
      WordWrap        =   -1  'True
   End
   Begin VB.Line Line2 
      X1              =   240
      X2              =   9600
      Y1              =   2040
      Y2              =   2040
   End
   Begin VB.Label Title 
      Alignment       =   2  'Center
      Caption         =   "VB 6.0 Example for Model 500-Serial"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   3120
      TabIndex        =   21
      Top             =   240
      Width           =   5415
   End
   Begin VB.Label Logo 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      Caption         =   "KEITHLEY"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   15.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   360
      TabIndex        =   20
      Top             =   240
      Width           =   1560
   End
   Begin VB.Line Line1 
      X1              =   240
      X2              =   9600
      Y1              =   840
      Y2              =   840
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Label1 - Filled in via code"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   360
      TabIndex        =   19
      Top             =   1080
      Width           =   9135
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label11 
      Alignment       =   1  'Right Justify
      Caption         =   "Response:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   15
      Top             =   7440
      Width           =   1140
   End
   Begin VB.Label Label9 
      Alignment       =   1  'Right Justify
      Caption         =   "SCPI Command:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   11
      Top             =   5880
      Width           =   1575
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Alan Ivons
' Keithley Instruments, Inc.
' 27 December 2001

Option Explicit

Sub Delay(sngSeconds As Single)
    
    Dim sngTargetTime As Single
    sngTargetTime = Timer + sngSeconds
    Do While sngTargetTime > Timer
        DoEvents
    Loop
    
End Sub

Private Sub cmdConfigPort_Click()   ' Configure the COM Port (RS-232 Serial Port) being used with Model 500-Serial
      
    MSComm1.CommPort = Val(txtCOMport.Text)             ' Specify COM Port being used
    MSComm1.DTREnable = True                            ' DTR line powers 500-Serial
    MSComm1.EOFEnable = False                           ' Don't look for end-of-file (EOF) character
    MSComm1.Handshaking = comRTS                        ' Specify hardware handshaking
    MSComm1.InBufferSize = 1024                         ' Default value
    MSComm1.InputLen = 0                                ' Read entire contents of receive buffer at one time
    MSComm1.InputMode = comInputModeText                ' Specify retrieved data as string data
    MSComm1.OutBufferSize = 512                         ' Default setting
    MSComm1.RThreshold = 0                              ' Prevent OnComm Event from firing
    MSComm1.RTSEnable = True                            ' Enable RTS line used for hardware handshaking
    MSComm1.Settings = txtBaudRate.Text & ",N,8,1"      ' Set Baud Rate, Parity, Data Bits, Stop Bits
    MSComm1.SThreshold = 0                              ' Prevent OnComm Event from firing

    cmdInit.Enabled = True      ' Enable Init Interface button
    cmdInit.SetFocus            ' Set focus to Init Interface button
        
End Sub

Private Sub cmdInit_Click()     ' Initialize the Model 500-Serial per Instruction Manual
    
    Dim intIcount As Integer    ' Counter variable                    ', intJcount As Integer
    Dim strBuffer As String     ' Without specifying length, string will hold ~2 billion chars
    
    On Err GoTo ErrorTrap
    
    If MSComm1.PortOpen = True Then
        MSComm1.PortOpen = False    ' Close RS-232 port for communications; prevent port "already open" error
    End If
        
    MSComm1.PortOpen = True         ' Open RS-232 port for communications; toggling COM port resets 500-Serial
    Delay 0.1                       ' Short delay
    
    For intIcount = 1 To 5
        MSComm1.Output = Chr(13)    ' Send carriage return (CR) to 500-Serial
        Delay 0.1                   ' Equivalent to Call Delay(0.1)
    Next intIcount
    
    ' Send the following commands to set up the 500-Serial
    ' 500-Serial commands terminate on CR (default); MSComm object requires that CR be included explicitly
    MSComm1.Output = "I" & Chr(13)      ' Send INIT command
    MSComm1.Output = "EC;0" & Chr(13)   ' Turn echo off
    MSComm1.Output = "H;1" & Chr(13)    ' Turn on hardware handshake
    MSComm1.Output = "X;0" & Chr(13)    ' Turn off Xon/Xoff
    MSComm1.Output = "TC;2" & Chr(13)   ' Set SERIAL Terminator to CR (default); both Xmit & Recv data
    MSComm1.Output = "TB;1" & Chr(13)   ' Set GPIB Terminator to Linefeed (LF); data received from bus
    MSComm1.Output = "EO;1"             ' Enable End or Identify (EOI)
    Delay 0.5
    
    intIcount = 0
    
    Do  ' Empty any garbage in the receive buffer; Response is complete when a CR is received
        DoEvents
        intIcount = intIcount + 1
        strBuffer = strBuffer & MSComm1.Input
    Loop Until (Right$(strBuffer, 1) = Chr(13)) Or (intIcount = 256)

    txtResponse.Text = strBuffer    ' Display strBuffer in Response textbox
    strBuffer = ""                  ' Set strBuffer to a NULL string
    MSComm1.Output = "C" & Chr(13)  ' Send Device Clear (DCL) command to reset instruments on bus
    
    cmdSendInterface.Enabled = True ' Enable Send Interace Command button
    cmdEnterResp.Enabled = True     ' Enable Enter Response button
    cmdSendSCPI.Enabled = True      ' Enable Send SCPI Command button
    
    txtResponse.Text = "Model 500-Serial has been initialized!"     ' Display an Init Complete Message
    
    txtSCPIcmd.SetFocus
    
    Exit Sub

ErrorTrap:     Resume Next
    
End Sub

Private Sub cmdSendInterface_Click()    ' Send commands to 500-Serial and non-SCPI commands to instrument
                                        ' All commands and addresses must be entered explicitly; e.g. if
                                        ' response is expected, EN;<address> must be sent to enter from bus
    
    MSComm1.Output = txtInterfaceCmd.Text & Chr(13)
    
    txtInterfaceCmd.SetFocus
    
End Sub

Private Sub cmdEnterResp_Click()
    
    Dim strBuffer As String     ' Without specifying length, string will hold ~2 billion chars

    Do      ' Read the receive buffer; Response complete when a CR is received
        DoEvents
        strBuffer = strBuffer & MSComm1.Input
    Loop Until Right$(strBuffer, 1) = Chr(13)
    
    txtResponse.Text = strBuffer    ' Display strBuffer in Response textbox

    strBuffer = ""                  ' Set strBuffer to a NULL string

    txtInterfaceCmd.SetFocus        ' Put cursor in Interface Cmd textbox
    
End Sub

Private Sub cmdSendSCPI_Click()     ' Send SCPI commands to instrument at specified GPIB address
    
    Dim strBuffer As String         ' Without specifying length, string will hold ~2 billion chars

    MSComm1.Output = "RE;" & txtAddress.Text & Chr(13)  ' Put instrument in remote; command is optional

    ' Line below sends SCPI commmand concatenated with CR to the instrument at the specified address
    MSComm1.Output = "OA;" & txtAddress.Text & ";" & txtSCPIcmd.Text & Chr(13)

    If Right(txtSCPIcmd.Text, 1) = "?" Then     ' If instrument response is expected, then read it
        MSComm1.Output = "EN;" & txtAddress.Text & Chr(13)
        
        Do      ' Read the receive buffer; Response complete when a CR is received
            DoEvents
            strBuffer = strBuffer & MSComm1.Input
        Loop Until Right$(strBuffer, 1) = Chr(13)
        
        txtResponse.Text = strBuffer    ' Display strBuffer in Response textbox

        strBuffer = ""                  ' Set strBuffer to a NULL string
    End If

    txtSCPIcmd.SetFocus                 ' Put cursor in Interface Cmd textbox

End Sub

Private Sub cmdInstruct_Click()
    
    frmInstruct.Show    ' Show the Instruction form

End Sub

Private Sub cmdExit_Click()

    Unload frmMain      ' Unload the Demo form

End Sub

Private Sub Form_Load()
    
    Label1.Caption = "* Start by pressing Config COM Port to configure the specified COM port."
    
    Label4.Caption = "* Press Init Interface to initialize the Model 500-Serial."
    
    Label5.Caption = "* Use this section to send any valid command to the 500-Serial, including non-SCPI GPIB commands." & vbCrLf _
    
    Label7.Caption = "* Use this section to send any valid SCPI command to the GPIB instrument." & vbCrLf _
    
    Label10.Caption = "* Output from GPIB Instrument and/or 500-Serial Interface is displayed below."
       
End Sub

Private Sub Form_Unload(Cancel As Integer)
    
    ' When the Main form is unloaded open the COM port if
    ' it is closed and then unload the Instruction form
    If MSComm1.PortOpen = True Then
        MSComm1.PortOpen = False
    End If
    
    Unload frmInstruct

End Sub

Private Sub txtCOMport_GotFocus()       ' If COM Port textbox gets focus, select its contents
    txtCOMport.SelStart = 0
    txtCOMport.SelLength = Len(txtCOMport.Text)
End Sub

Private Sub txtBaudRate_GotFocus()      ' If Baud Rate textbox gets focus, select its contents
    txtBaudRate.SelStart = 0
    txtBaudRate.SelLength = Len(txtBaudRate.Text)
End Sub

Private Sub txtInterfaceCmd_GotFocus()  ' If Interface Command textbox gets focus, select its contents
    txtInterfaceCmd.SelStart = 0
    txtInterfaceCmd.SelLength = Len(txtInterfaceCmd.Text)
End Sub

Private Sub txtAddress_GotFocus()       ' If GPIB Address textbox gets focus, select its contents
    txtAddress.SelStart = 0
    txtAddress.SelLength = Len(txtAddress.Text)
End Sub

Private Sub txtSCPIcmd_GotFocus()       ' If SCPI Command textbox gets focus, select its contents
    txtSCPIcmd.SelStart = 0
    txtSCPIcmd.SelLength = Len(txtSCPIcmd.Text)
End Sub

Private Sub txtInterfaceCmd_Change()    ' If content of Interface Cmd textbox changes, clear Response textbox
    txtResponse.Text = ""
End Sub

Private Sub txtSCPIcmd_Change()         ' If content of SCPI Command textbox changes, clear Response textbox
    txtResponse.Text = ""
End Sub


